#ifdef _DRIVER_CUSTOM

#include "DriverLayerCustom.h"
#include <fcntl.h>
#include <sys/ioctl.h>

#define _CTRL 0
#define _INT 1
#define _BULK 2
#define _ISO 3

#define SET_DESC_INDEX                  0x0002
#define SET_IN_ENDPOINT                 0x0003
#define SET_OUT_ENDPOINT                0x0004
#define GET_ENDPOINT_DESCRIPTOR         0x0005
#define GET_INTERFACE_DESCRIPTOR        0x0006
#define GET_CONFIGURATION_DESCRIPTOR    0x0007
#define SET_TRANSFER_TYPE               0x0008
#define SET_TIMEOUT                     0x0009

driverLayerCustom::driverLayerCustom () {//Ok

    explenrecv = MAX_LEN_MSG;
    pl = new platformLayerLinux();
    findU4ABoards();
}

driverLayerCustom::~driverLayerCustom() {// Ok

    l->printLog("driverLayerCustom Destructor",true,true);
    l = NULL;
    delete pl;
}

void driverLayerCustom::findU4ABoards() {// Ok

    map<int,itemDsc> dscs;
    map<int,itemDsc>::iterator it;
    itemDsc ds;
    itemBoard itb;
    dscEndpoint ep;
    int temp, num;

    dscs = pl->getDescriptors();

    for (it = dscs.begin();it != dscs.end();it++) {
        ds = it->second;
        itb.serial = atoi((const char *)&ds.strSerialNumber[0]);
        itb.qtyep = ds.qtyep;
        itb.devhnd = ds.fd;
        for (int i=0 ; i < itb.qtyep ; i++){
            temp = (int)(((unsigned char)ds.stdEndpointDsc[i][3]) & 0x03);
            num = (int)((unsigned char)ds.stdEndpointDsc[i][2]);
            switch (temp) {
                case 0:
                    if (num > 127) {
                        ep.tdscin = CTRL_IN;
                        ep.tdscout = NULL_OUT;
                        num -= 128;
                    }
                    else {
                       ep.tdscin = NULL_IN;
                        ep.tdscout = CTRL_OUT;
                   }
                    break;
                case 1:
                    if (num > 127) {
                        ep.tdscin = ISO_IN;
                        ep.tdscout = NULL_OUT;
                        num -= 128;
                    }
                    else {
                        ep.tdscin = NULL_IN;
                        ep.tdscout = ISO_OUT;
                    }
                    break;
                case 2:
                    if (num > 127) {
                        ep.tdscin = BULK_IN;
                        ep.tdscout = NULL_OUT;
                        num -= 128;
                    }
                    else {
                        ep.tdscin = NULL_IN;
                        ep.tdscout = BULK_OUT;
                    }
                    break;
                case 3:
                    if (num > 127) {
                        ep.tdscin = INT_IN;
                        ep.tdscout = NULL_OUT;
                        num -= 128;
                    }
                    else {
                        ep.tdscin = NULL_IN;
                        ep.tdscout = INT_OUT;
                    }
                    break;
            }
            ep.epnum = num;
            itb.eps[i] = ep;
        };
        boards.insert(pair<int,itemBoard>(it->first,itb));
    }
}

int driverLayerCustom::getInstance(int board) {

    map<int,itemBoard>::iterator it;

    it = boards.find(board);
    return it->second.devhnd;

}

int driverLayerCustom::unBuildBoardPart(int buffer) {

    return ((int)(buffer / 1000));
}

int driverLayerCustom::unBuildDscPart(int buffer) {

    return ((int) (buffer%1000));
}

int* driverLayerCustom::getU4ABoards(int& cant) {//Ok

    int *iboards;
    map<int,itemBoard>::iterator it;

    cant = boards.size();
    if (cant > 0) {
        iboards = new int[cant];
        for (int i=0; i < cant ; i++) {
            it = boards.find(i);
            iboards[i] = it->second.serial;
        };
        return iboards;
    };
    return NULL;
}

int driverLayerCustom::qtyDsc(int board) {//Ok

    map<int,itemBoard>::iterator it;

    it = boards.find(board);
    return (it->second.qtyep);
}

dscEndpoint* driverLayerCustom::getEndpointDsc(int board, int iter) {//Ok

    map<int,itemBoard>::iterator it;
    dscEndpoint* endps;

    it = boards.find(board);
    endps = new dscEndpoint();
    endps->epnum = it->second.eps[iter].epnum;
    endps->tdscin = it->second.eps[iter].tdscin;
    endps->tdscout = it->second.eps[iter].tdscout;
    return endps;
}

int driverLayerCustom::open(int board, int dsc, usbin dscin) {//Ok

    int nbuff;
    char buffer[MAX_LEN_MSG];

    nbuff = (board * 1000) + (128+dsc);
    sprintf(buffer,"%d",nbuff);
    l->printLog(buffer, true, true);
    return nbuff;
}

int driverLayerCustom::open(int board, int dsc, usbout dscout) {//Ok

    int nbuff;
    char buffer[MAX_LEN_MSG];

    nbuff = (board * 1000) + dsc;
    sprintf(buffer,"%d",nbuff);
    l->printLog(buffer, true, true);
    return nbuff;
}

bool driverLayerCustom::close(int buffer) {//Ok

    int fd;

    fd = getInstance(unBuildBoardPart(buffer));
    close(fd);
    return true;
}

bool driverLayerCustom::sendInt(int buffer, char *msg, int len, int timeout) {//Ok

    char temp[MAX_LEN_MSG];
    int ret, fd, ioparam;

    sprintf(temp,"DriverLayer ==> SendInt, Endpoint = %d",unBuildDscPart(buffer));
    l->printLog(temp, true, true);
    l->printLog("Message =",false, true);
    for (int i=0; i< len; i++) {
        sprintf(temp," %X ",msg[i]);
        l->printLog(temp, false, false);
    };
    l->printLogLn();

    fd = getInstance(unBuildBoardPart(buffer));
    ioparam = _INT;
    ioctl(fd, SET_TRANSFER_TYPE, &ioparam);
    ioparam = unBuildDscPart(buffer);
    ioctl(fd, SET_OUT_ENDPOINT, &ioparam);
    ioctl(fd, SET_TIMEOUT, &timeout);
    ret = write(fd,msg, len);
    if (ret == len) {
        return true;
    }
    else {
        return false;
    }
}

bool driverLayerCustom::sendCtrl(int buffer, char *msg, int len, int timeout) {

    char temp[MAX_LEN_MSG];
    int ret, fd, ioparam;

    sprintf(temp,"DriverLayer ==> SendCtrl, Endpoint = %d",unBuildDscPart(buffer));
    l->printLog(temp, true, true);
    l->printLog("Message =",false, true);
    for (int i=0; i< len; i++) {
        sprintf(temp," %X ",msg[i]);
        l->printLog(temp, false, false);
    };
    l->printLogLn();

    fd = getInstance(unBuildBoardPart(buffer));
    ioparam = _CTRL;
    ioctl(fd, SET_TRANSFER_TYPE, &ioparam);
    ioparam = unBuildDscPart(buffer);
    ioctl(fd, SET_OUT_ENDPOINT, &ioparam);
    ioctl(fd, SET_TIMEOUT, &timeout);
    ret = write(fd,msg, len);
    if (ret == len) {
        return true;
    }
    else {
        return false;
    }
}

bool driverLayerCustom::sendIso(int buffer, char *msg, int len, int timeout) {

    char temp[MAX_LEN_MSG];
    int ret, fd, ioparam;

    sprintf(temp,"DriverLayer ==> SendIso, Endpoint = %d",unBuildDscPart(buffer));
    l->printLog(temp, true, true);
    l->printLog("Message =",false, true);
    for (int i=0; i< len; i++) {
        sprintf(temp," %X ",msg[i]);
        l->printLog(temp, false, false);
    };
    l->printLogLn();

    fd = getInstance(unBuildBoardPart(buffer));
    ioparam = _ISO;
    ioctl(fd, SET_TRANSFER_TYPE, &ioparam);
    ioparam = unBuildDscPart(buffer);
    ioctl(fd, SET_OUT_ENDPOINT, &ioparam);
    ioctl(fd, SET_TIMEOUT, &timeout);
    ret = write(fd,msg, len);
    if (ret == len) {
        return true;
    }
    else {
        return false;
    }
}

bool driverLayerCustom::sendBulk(int buffer, char *msg, int len, int timeout) {//Ok

    char temp[MAX_LEN_MSG];
    int ret, fd, ioparam;

    sprintf(temp,"DriverLayer ==> SendBulk, Endpoint = %d",unBuildDscPart(buffer));
    l->printLog(temp, true, true);
    l->printLog("Message =",false, true);
    for (int i=0; i< len; i++) {
        sprintf(temp," %X ",msg[i]);
        l->printLog(temp, false, false);
    };
    l->printLogLn();

    fd = getInstance(unBuildBoardPart(buffer));
    ioparam = _BULK;
    ioctl(fd, SET_TRANSFER_TYPE, &ioparam);
    ioparam = unBuildDscPart(buffer);
    ioctl(fd, SET_OUT_ENDPOINT, &ioparam);
    ioctl(fd, SET_TIMEOUT, &timeout);
    ret = write(fd,msg, len);
    if (ret == len) {
        return true;
    }
    else {
        return false;
    }
}

char* driverLayerCustom::receiveInt(int buffer, int& recv, bool& ok, int timeout) {//Ok

    char temp[MAX_LEN_MSG];
    char *msg = new char[MAX_LEN_MSG];
    int fd, ioparam;

    fd = getInstance(unBuildBoardPart(buffer));
    ioparam = _INT;
    ioctl(fd, SET_TRANSFER_TYPE, &ioparam);
    ioparam = unBuildDscPart(buffer);
    ioctl(fd, SET_IN_ENDPOINT, &ioparam);
    ioctl(fd, SET_TIMEOUT, &timeout);
    recv = read(fd,msg, MAX_LEN_MSG);
    if (recv > 0) {
        ok = true;
    }
    else {
        ok = false;
    }
    sprintf(temp,"DriverLayer ==> ReceiveInt, Endpoint = %d",unBuildDscPart(buffer));
    l->printLog(temp, true, true);
    l->printLog("Message =",false, true);
    for (int i=0; i< recv; i++) {
        sprintf(temp," %X ",msg[i]);
        l->printLog(temp, false, false);
    };
    l->printLogLn();
    sprintf(temp,"Se recibieron %d bytes.",recv);
    l->printLog(temp, true, true);
    l->printLogLn();
    return msg;
}

char* driverLayerCustom::receiveCtrl(int buffer, int& recv, bool& ok, int timeout) {

    char temp[MAX_LEN_MSG];
    char *msg = new char[MAX_LEN_MSG];
    int fd, ioparam;

    fd = getInstance(unBuildBoardPart(buffer));
    ioparam = _CTRL;
    ioctl(fd, SET_TRANSFER_TYPE, &ioparam);
    ioparam = unBuildDscPart(buffer);
    ioctl(fd, SET_IN_ENDPOINT, &ioparam);
    ioctl(fd, SET_TIMEOUT, &timeout);
    recv = read(fd,msg, MAX_LEN_MSG);
    if (recv > 0) {
        ok = true;
    }
    else {
        ok = false;
    }
    sprintf(temp,"DriverLayer ==> ReceiveCtrl, Endpoint = %d",unBuildDscPart(buffer));
    l->printLog(temp, true, true);
    l->printLog("Message =",false, true);
    for (int i=0; i< recv; i++) {
        sprintf(temp," %X ",msg[i]);
        l->printLog(temp, false, false);
    };
    l->printLogLn();
    sprintf(temp,"Se recibieron %d bytes.",recv);
    l->printLog(temp, true, true);
    l->printLogLn();
    return msg;
}

char* driverLayerCustom::receiveIso(int buffer, int& recv, bool& ok, int timeout) {

    char temp[MAX_LEN_MSG];
    char *msg = new char[MAX_LEN_MSG];
    int fd, ioparam;

    fd = getInstance(unBuildBoardPart(buffer));
    ioparam = _ISO;
    ioctl(fd, SET_TRANSFER_TYPE, &ioparam);
    ioparam = unBuildDscPart(buffer);
    ioctl(fd, SET_IN_ENDPOINT, &ioparam);
    ioctl(fd, SET_TIMEOUT, &timeout);
    recv = read(fd,msg, MAX_LEN_MSG);
    if (recv > 0) {
        ok = true;
    }
    else {
        ok = false;
    }
    sprintf(temp,"DriverLayer ==> ReceiveIso, Endpoint = %d",unBuildDscPart(buffer));
    l->printLog(temp, true, true);
    l->printLog("Message =",false, true);
    for (int i=0; i< recv; i++) {
        sprintf(temp," %X ",msg[i]);
        l->printLog(temp, false, false);
    };
    l->printLogLn();
    sprintf(temp,"Se recibieron %d bytes.",recv);
    l->printLog(temp, true, true);
    l->printLogLn();
    return msg;
}

char* driverLayerCustom::receiveBulk(int buffer, int& recv, bool& ok, int timeout) {//Ok

    char temp[MAX_LEN_MSG];
    char *msg = new char[MAX_LEN_MSG];
    int fd, ioparam;

    fd = getInstance(unBuildBoardPart(buffer));
    ioparam = _BULK;
    ioctl(fd, SET_TRANSFER_TYPE, &ioparam);
    ioparam = unBuildDscPart(buffer);
    ioctl(fd, SET_IN_ENDPOINT, &ioparam);
    ioctl(fd, SET_TIMEOUT, &timeout);
    recv = read(fd,msg, MAX_LEN_MSG);
    if (recv > 0) {
        ok = true;
    }
    else {
        ok = false;
    }
    sprintf(temp,"DriverLayer ==> ReceiveBulk, Endpoint = %d",unBuildDscPart(buffer));
    l->printLog(temp, true, true);
    l->printLog("Message =",false, true);
    for (int i=0; i< recv; i++) {
        sprintf(temp," %X ",msg[i]);
        l->printLog(temp, false, false);
    };
    l->printLogLn();
    sprintf(temp,"Se recibieron %d bytes.",recv);
    l->printLog(temp, true, true);
    l->printLogLn();
    return msg;
}

#endif
